 
import pandas as pd   
import pickle
   
# Assuming the dataset is loaded as a DataFrame named 'fastfood'   
   
# Recommended Daily Intake (RDI) values   
rdi_protein = 50   
rdi_fiber = 25   
rdi_vit_a = 5000   
rdi_vit_c = 60   
rdi_calcium = 1000   
rdi_sat_fat = 20   
rdi_trans_fat = 2   
rdi_sugar = 50   
rdi_sodium = 2400   
rdi_total_carb = 300   
   
# Calculate the percentage of RDI for each nutrient   
fastfood['protein_score'] = (fastfood['protein'] / rdi_protein) * 100   
fastfood['fiber_score'] = (fastfood['fiber'] / rdi_fiber) * 100   
fastfood['vit_a_score'] = (fastfood['vit_a'] / rdi_vit_a) * 100   
fastfood['vit_c_score'] = (fastfood['vit_c'] / rdi_vit_c) * 100   
fastfood['calcium_score'] = (fastfood['calcium'] / rdi_calcium) * 100   
fastfood['sat_fat_score'] = (fastfood['sat_fat'] / rdi_sat_fat) * 100   
fastfood['trans_fat_score'] = (fastfood['trans_fat'] / rdi_trans_fat) * 100   
fastfood['sugar_score'] = (fastfood['sugar'] / rdi_sugar) * 100   
fastfood['sodium_score'] = (fastfood['sodium'] / rdi_sodium) * 100   
fastfood['total_carb_score'] = (fastfood['total_carb'] / rdi_total_carb) * 100   
   
# Calculate the Comprehensive Modified NRF Index   
fastfood['comprehensive_modified_nrf_index'] = (fastfood['protein_score'] + fastfood['fiber_score'] + fastfood['vit_a_score'] + fastfood['vit_c_score'] + fastfood['calcium_score']) - (fastfood['sat_fat_score'] + fastfood['trans_fat_score'] + fastfood['sugar_score'] + fastfood['sodium_score'] + fastfood['total_carb_score']) 

print(fastfood)
pickle.dump(fastfood,open("./ref_result/fastfood.pkl","wb"))
